function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import React from 'react';

var Matcher = function () {
  function Matcher(name, options, factory) {
    _defineProperty(this, "options", void 0);

    _defineProperty(this, "propName", void 0);

    _defineProperty(this, "inverseName", void 0);

    _defineProperty(this, "factory", void 0);

    if ("production" !== process.env.NODE_ENV) {
      if (!name || name.toLowerCase() === 'html') {
        throw new Error("The matcher name \"" + name + "\" is not allowed.");
      }
    }

    this.options = _extends({}, options);
    this.propName = name;
    this.inverseName = "no" + (name.charAt(0).toUpperCase() + name.slice(1));
    this.factory = factory || null;
  }

  var _proto = Matcher.prototype;

  _proto.createElement = function createElement(match, props) {
    var element = null;

    if (this.factory) {
      element = React.createElement(this.factory, props, match);
    } else {
      element = this.replaceWith(match, props);
    }

    if ("production" !== process.env.NODE_ENV) {
      if (typeof element !== 'string' && !React.isValidElement(element)) {
        throw new Error("Invalid React element created from " + this.constructor.name + ".");
      }
    }

    return element;
  };

  _proto.doMatch = function doMatch(string, pattern, callback) {
    var matches = string.match(pattern instanceof RegExp ? pattern : new RegExp(pattern, 'i'));

    if (!matches) {
      return null;
    }

    return _extends({}, callback(matches), {
      match: matches[0]
    });
  };

  _proto.onBeforeParse = function onBeforeParse(content, props) {
    return content;
  };

  _proto.onAfterParse = function onAfterParse(content, props) {
    return content;
  };

  return Matcher;
}();

export { Matcher as default };